<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Slug extends Model
{
    //
    protected $table='slugs';

    public function basicInfo()
    {
        return $this->belongsTo(BasicInfo::class, 'user_id', 'user_id');
    }
    public function education()
    {
        return $this->hasMany(Education::class, 'user_id', 'user_id');
    }
    public function experience()
    {
        return $this->hasMany(Experience::class, 'user_id', 'user_id');  
    }
    public function backgroundImg()
    {
        return $this->hasMany(BackGroundImg::class, 'user_id', 'user_id');
    }
    public function socialLink(){
        return $this->hasOne(socialLink::class,'user_id','user_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }
}
