import { createApp, h } from 'vue';
import { createInertiaApp } from '@inertiajs/vue3';
import Swiper from 'swiper';
import { Navigation, Pagination, Autoplay } from 'swiper/modules';
import 'swiper/css';
import 'swiper/css/pagination';

console.log('Starting Inertia app initialization...');

createInertiaApp({
  resolve: (name) => {
    console.log('Resolving component:', name);
    return import(`./Pages/${name}.vue`);
  },
  setup({ el, App, props, plugin }) {
    console.log('Setting up Vue app with element:', el);
    console.log('App component:', App);
    console.log('Props:', props);

    const app = createApp({ render: () => h(App, props) })
      .use(plugin);

    console.log('Mounting app to element:', el);
    app.mount(el);
    console.log('App mounted successfully');
  },
});